<?php
# WP SUPER CACHE 1.2
# WP SUPER CACHE 0.8.9.1
# AL ADVANCED CACHE 1.0
$cache_fname = dirname( __FILE__ ) . "/plugins/airlift/buffer/cache.php";
$helper_fname = dirname( __FILE__ ) . '/plugins/airlift/helper.php';

if (file_exists($cache_fname) && file_exists($helper_fname)) {
	require_once $cache_fname;
	require_once $helper_fname;

	$GLOBALS['al_cache_skip_cookies'] = ["woocommerce_cart_hash", "woocommerce_items_in_cart"];

	function hasIgnoredScript() {
		if (in_array(
			basename($_SERVER['SCRIPT_FILENAME']),
			array(
				'wp-app.php',
				'xmlrpc.php',
				'wp-cron.php',
			)
		)) {
			return true;
		}
		if (strstr($_SERVER['SCRIPT_FILENAME'], 'wp-includes/js')) {
			return true;
		}
		return false;
	}

	function hasIgnoredHeaders() {
		if (!empty($_SERVER['HTTP_X_WP_NONCE']) || !empty($_SERVER['HTTP_X_HTTP_METHOD_OVERRIDE']) || !empty($_SERVER['HTTP_AUTHORIZATION'])) {
			return true;
		}
		return false;
	}

	function hasIgnoredCookies($ignored_cookies, $skip_cookies) {
		if (!is_array($_COOKIE) || empty($_COOKIE)) {
			return false;
		}

		foreach (array_keys($_COOKIE) as $cookie_name) {
			$is_skipped = false;

			// First check if cookie should be skipped from ignore list
			foreach ($skip_cookies as $skip_cookie) {
				if (ALHelper::safePregMatch($skip_cookie, $cookie_name)) {
					$is_skipped = true;
					break;
				}
			}

			// If cookie is not in skip list, check if it matches ignore patterns
			if (!$is_skipped) {
				foreach ($ignored_cookies as $ignored_cookie) {
					if (ALHelper::safePregMatch($ignored_cookie, $cookie_name)) {
						return true;
					}
				}
			}
		}
		return false;
	}

	function hasIgnoredUserAgents($ignored_user_agents) {
		foreach ($ignored_user_agents as $ignored_ua) {
			if(ALHelper::safePregMatch($ignored_ua, $_SERVER['HTTP_USER_AGENT'])) {
				return true;
			}
		}
		return false;
	}

	function isIgnoredRequestMethod($allowed_methods) {
		if (in_array($_SERVER['REQUEST_METHOD'], $allowed_methods)) {
			return false;
		}
		return true;
	}

	function canCachePage() {
		if (hasIgnoredScript()) {
			return false;
		}
		if (hasIgnoredHeaders()) {
			return false;
		}

		$ignored_cookies = ["/^wp/", "/^wordpress/", "/^comment_author/"];
		$ignored_user_agents = ["/Zapier/i"];
		$skip_cookies_to_ignore_optimization = ["/wordpress_test_cookie/", "/wordpress_ic_session/", "/wp-wpml_current_language/", "/wp_woocommerce_session/", "/wp-settings/"];
		$allowed_methods = array("GET", "HEAD");
		if (hasIgnoredCookies($ignored_cookies, $skip_cookies_to_ignore_optimization) || hasIgnoredUserAgents($ignored_user_agents) || isIgnoredRequestMethod($allowed_methods)) {
			return false;
		}
		return true;
	}

	if (canCachePage()) {
		$socache = new ALCache();
		$socache->startCaching();
	}
}